<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 100);
			$table->string('password', 255);
			$table->string('email', 100);
			$table->text('meta');
			$table->enum('status', array('active', 'inactive', 'suspended', 'banned'));
			$table->integer('role_id')->unsigned();
			$table->tinyInteger('no_delete')->default('0');
			$table->tinyInteger('validated')->default('0');
			$table->string('remember_token', 100);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}