<?php

namespace shop.Episodes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Episodes extends Model 
{

    protected $table = 'Episodes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'Title', 'Price', 'Duration', 'Cover', 'CategoryId');

    public function category()
    {
        return $this->hasMany('Episodes', 'CategoryId');
    }

    public function sessions()
    {
        return $this->belongsTo('Sessions');
    }

}