<?php

namespace shop.Payment_Episode;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment_Episode extends Model 
{

    protected $table = 'Payment_Episode';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'PayId', 'EpisodeId', 'created_at');

    public function episodes()
    {
        return $this->belongsToMany('Payments');
    }

    public function payments()
    {
        return $this->belongsToMany('Episodes');
    }

}