<?php

namespace shop.Sessions;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sessions extends Model 
{

    protected $table = 'Sessions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('Id', 'Title', 'DownloadUrl', 'EpisodeId', 'created_at');

    public function episode()
    {
        return $this->hasMany('Sessions', 'EpisodeId');
    }

}