<?php

namespace shop.Sessions;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sessions extends Eloquent {

	protected $table = 'Sessions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('Id', 'Title', 'DownloadUrl', 'EpisodeId', 'created_at');

	public function episode()
	{
		return $this->hasMany('Sessions', 'EpisodeId');
	}

}