<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('Customer_Id')->references('Id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('Category')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('image', function(Blueprint $table) {
			$table->foreign('Product_ID')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('Order_ID')->references('Id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('Product_ID')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('Parent')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('Customer_ID')->references('Id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_Customer_Id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_Category_foreign');
		});
		Schema::table('image', function(Blueprint $table) {
			$table->dropForeign('image_Product_ID_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_Order_ID_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_Product_ID_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_Parent_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_Customer_ID_foreign');
		});
	}
}