<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('name', 'governorate_id');

    public function state()
    {
        return $this->belongsTo('App\Governorate');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Client');
    }

    public function donationRequests()
    {
        return $this->hasMany('App\DonationRequest');
    }

}