<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->text('path');
			$table->string('extension', 16)->nullable();
			$table->softDeletes();
			$table->longText('content');
			$table->text('preview')->nullable();
			$table->text('keywords')->nullable();
			$table->integer('author')->unsigned();
			$table->text('copyright')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}