<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191)->unique();
			$table->enum('type', array('files', 'folders', 'events'));
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}