<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class News extends Eloquent {

	protected $table = 'news';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('published_at', 'title', 'user_id', 'content', 'team', 'validated', 'team_id');

	public function team()
	{
		return $this->belongsTo('App\Team');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function pictures()
	{
		return $this->hasMany('App\Picture');
	}

}