<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'password', 'level', 'email', 'school_year', 'department_id', 'validated');

    public function department()
    {
        return $this->belongsTo('App\Department');
    }

    public function teams()
    {
        return $this->belongsToMany('App\Team')->withPivot(['validated','level']);
    }

    public function news()
    {
        return $this->hasMany('App\News');
    }

    public function events()
    {
        return $this->hasMany('App\Event');
    }

    public function contents()
    {
        return $this->hasMany('App\Content');
    }

    public function contentDeleted()
    {
        return $this->hasMany('App\ContentRecord');
    }

    public function notification()
    {
        return $this->hasMany('App\Notification');
    }

    public function picture()
    {
        return $this->hasMany('App\Picture');
    }

}