<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannersTable extends Migration {

	public function up()
	{
		Schema::create('banners', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title');
			$table->text('description');
			$table->string('bannerable_type');
			$table->integer('bannerable_id')->unsigned();
			$table->string('bannerable_table');
			$table->boolean('is_enabled');
			$table->integer('index')->unique()->unsigned();
			$table->string('url');
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('banners');
	}
}