<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDataStoresTable extends Migration {

	public function up()
	{
		Schema::create('data_stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('type_id')->unsigned()->nullable()->index();
			$table->string('title');
			$table->text('description')->nullable();
			$table->json('data')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('data_stores');
	}
}