<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFaqsTable extends Migration {

	public function up()
	{
		Schema::create('faqs', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->integer('index')->unique()->unsigned();
			$table->string('question')->index();
			$table->text('answer');
			$table->integer('helpful_no')->unsigned()->default('0');
			$table->integer('helpful_yes')->unsigned()->default('0');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('created_by')->unsigned()->nullable();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->boolean('is_enabled')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('faqs');
	}
}