<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVouchersTable extends Migration {

	public function up()
	{
		Schema::create('vouchers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('brand_id')->unsigned()->nullable()->index();
			$table->string('code', 63)->unique()->nullable();
			$table->boolean('is_enabled')->index();
			$table->boolean('is_expired')->index()->default(false);
			$table->integer('quota')->unsigned()->nullable()->index();
			$table->integer('quota_fulfilled')->unsigned()->nullable()->index();
			$table->integer('quota_buffered')->unsigned()->nullable()->index();
			$table->string('title', 127);
			$table->text('description')->nullable();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('vouchers');
	}
}