<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRewardsTable extends Migration {

	public function up()
	{
		Schema::create('rewards', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title');
			$table->text('description');
			$table->boolean('is_enabled')->default(false);
			$table->integer('quantity')->unsigned()->nullable();
			$table->string('given_type');
			$table->string('slug');
			$table->string('ref_table')->nullable();
			$table->nullableMorphs('ref');
			$table->json('custom_properties')->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->string('given_value');
		});
	}

	public function down()
	{
		Schema::drop('rewards');
	}
}