<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkinDiaryTemplateTable extends Migration {

	public function up()
	{
		Schema::create('skin_diary_template', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title')->unique();
			$table->text('description')->nullable();
			$table->string('collection');
			$table->smallInteger('index')->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('skin_diary_template');
	}
}