<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid')->unique();
			$table->string('name');
			$table->tinyInteger('gender')->unsigned()->nullable()->index();
			$table->date('dob')->nullable();
			$table->string('pob')->nullable();
			$table->integer('user_id')->unique()->unsigned();
			$table->string('number', 127)->unique()->nullable();
			$table->boolean('is_enabled')->index()->default(true);
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}