<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDataStorePivotsTable extends Migration {

	public function up()
	{
		Schema::create('data_store_pivots', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('ref_id')->unsigned()->index();
			$table->string('ref_model', 127)->index();
			$table->string('ref_table', 63)->index();
			$table->integer('data_id')->unsigned()->index();
			$table->string('slug', 63)->nullable()->index();
			$table->integer('index')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('data_store_pivots');
	}
}