<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnablersTable extends Migration {

	public function up()
	{
		Schema::create('enablers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->uuid('uuid')->unique();
			$table->integer('ref_id')->unsigned()->index();
			$table->string('ref_model', 127)->index();
			$table->string('ref_table', 127)->index();
			$table->timestamp('enabled_at')->nullable();
			$table->timestamp('disabled_at')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('enablers');
	}
}