<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid')->unique();
			$table->integer('brand_id')->unsigned()->nullable()->index();
			$table->string('title')->index();
			$table->text('description')->nullable();
			$table->float('weight')->nullable();
			$table->json('dimension')->nullable();
			$table->integer('unit_id')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->boolean('is_digital')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}