<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariantsTable extends Migration {

	public function up()
	{
		Schema::create('variants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid')->unique();
			$table->string('title')->unique();
			$table->string('sku', 127)->unique()->nullable();
			$table->integer('product_id')->unsigned()->index();
			$table->float('stock_total')->nullable();
			$table->float('stock_buffered')->nullable();
			$table->boolean('is_enabled')->index()->default(true);
			$table->boolean('is_available')->index()->default(true);
			$table->json('dimension')->nullable();
			$table->float('weight')->nullable();
			$table->integer('unit_id')->unsigned()->nullable()->index();
			$table->text('description')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('variants');
	}
}