<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommercePeriodicReportsTable extends Migration {

	public function up()
	{
		Schema::create('commerce_periodic_reports', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->nullableMorphs('ref');
			$table->string('ref_table')->nullable();
			$table->string('event_type');
			$table->string('period_type');
			$table->string('period_value');
			$table->float('value');
			$table->json('custom_properties')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('commerce_periodic_reports');
	}
}