<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestsTable extends Migration {

	public function up()
	{
		Schema::create('quests', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title');
			$table->string('event_name');
			$table->text('description')->nullable();
			$table->integer('point')->unsigned();
			$table->boolean('repeateable')->default(false);
			$table->boolean('multipliable')->default(false);
			$table->string('requirement_type');
			$table->string('requirement_subject_relation');
			$table->integer('requirement_value')->unsigned();
			$table->string('requirement_field')->nullable();
			$table->string('requirement_operator', 5)->default('=');
			$table->integer('quota')->unsigned()->nullable();
			$table->smallInteger('limit_interval')->unsigned()->nullable();
			$table->boolean('limit_per_user')->default(false);
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->integer('created_by')->unsigned();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('quests');
	}
}