<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReputationsTable extends Migration {

	public function up()
	{
		Schema::create('reputations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('quest_id')->unsigned()->nullable();
			$table->string('name');
			$table->integer('point')->unsigned();
			$table->morphs('subject');
			$table->integer('user_id')->unsigned();
			$table->json('meta')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reputations');
	}
}