<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewCategoryTable extends Migration {

	public function up()
	{
		Schema::create('review_category', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->text('description')->nullable();
			$table->boolean('is_enabled');
			$table->string('index')->unique()->nullable();
			$table->uuid('uuid')->unique();
		});
	}

	public function down()
	{
		Schema::drop('review_category');
	}
}