<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkinTemplateSlotTable extends Migration {

	public function up()
	{
		Schema::create('skin_template_slot', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('template_id')->unsigned();
			$table->uuid('uuid')->unique();
			$table->string('title');
			$table->string('type', 20)->default('image');
			$table->string('source');
			$table->string('text')->nullable();
			$table->json('manipulations');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('skin_template_slot');
	}
}