<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function pack()
    {
        return $this->belongsTo('Pack');
    }

    public function is_suspended()
    {
        return $this->belongsTo('SuspendedAccounts');
    }

}