<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nom', 30);
			$table->bigInteger('user_id')->unsigned();
			$table->string('logo', 250);
			$table->string('ice', 15);
			$table->bigInteger('pack_id')->unsigned();
			$table->bigInteger('is_suspended')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}