<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('charge_vehicules', function(Blueprint $table) {
			$table->foreign('Vehicule_id')->references('id')->on('vehicules')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('Type_service_id')->references('id')->on('services_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('fornisseur_id')->references('id')->on('fournisseurs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vehicule_employes', function(Blueprint $table) {
			$table->foreign('employe_id')->references('id')->on('employes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vehicule_employes', function(Blueprint $table) {
			$table->foreign('vehecule_id')->references('id')->on('vehicules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_vehicules', function(Blueprint $table) {
			$table->foreign('vehicule_id')->references('id')->on('vehicules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_vehicules', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('factures', function(Blueprint $table) {
			$table->foreign('idService')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('pack_id')->references('id')->on('packs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('is_suspended')->references('id')->on('suspended_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suspended_accounts', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('charge_vehicules', function(Blueprint $table) {
			$table->dropForeign('charge_vehicules_Vehicule_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_Type_service_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_fornisseur_id_foreign');
		});
		Schema::table('vehicule_employes', function(Blueprint $table) {
			$table->dropForeign('vehicule_employes_employe_id_foreign');
		});
		Schema::table('vehicule_employes', function(Blueprint $table) {
			$table->dropForeign('vehicule_employes_vehecule_id_foreign');
		});
		Schema::table('service_vehicules', function(Blueprint $table) {
			$table->dropForeign('service_vehicules_vehicule_id_foreign');
		});
		Schema::table('service_vehicules', function(Blueprint $table) {
			$table->dropForeign('service_vehicules_service_id_foreign');
		});
		Schema::table('factures', function(Blueprint $table) {
			$table->dropForeign('factures_idService_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_pack_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_is_suspended_foreign');
		});
		Schema::table('suspended_accounts', function(Blueprint $table) {
			$table->dropForeign('suspended_accounts_company_id_foreign');
		});
	}
}