<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractorsTable extends Migration {

	public function up()
	{
		Schema::create('Contractors', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('type_id');
			$table->string('first_name');
			$table->string('second_name');
			$table->string('middle_name');
			$table->string('phone');
			$table->string('email')->unique();
			$table->string('delivery_address');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Contractors');
	}
}