<?php

namespace Ticket;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'Tickets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Product()
    {
        return $this->hasOne('Product', 'product_id');
    }

    public function Contractor()
    {
        return $this->hasOne('Contractor', 'contractor_id');
    }

    public function Statuses()
    {
        return $this->hasMany('Ticket', 'id');
    }

}