<?php

namespace Ticket;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'Tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Product()
	{
		return $this->hasOne('Product', 'product_id');
	}

	public function Contractor()
	{
		return $this->hasOne('Contractor', 'contractor_id');
	}

	public function Statuses()
	{
		return $this->hasMany('Ticket', 'id');
	}

}