<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCreancesDettesFondsTable extends Migration {

	public function up()
	{
		Schema::create('creances_dettes_fonds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->timestamp('date')->nullable();
			$table->softDeletes();
			$table->string('slug', 255)->nullable();
			$table->integer('id_utilisateurNiveau4')->unsigned()->nullable();
			$table->integer('id_utilisateur')->unsigned()->nullable();
			$table->integer('id_typeCaisse')->unsigned()->nullable();
			$table->string('type', 255)->nullable();
			$table->integer('montant')->nullable();
			$table->integer('montantRembourse')->nullable()->default('0');
			$table->string('motif', 255)->nullable();
			$table->integer('dureeAmortissement')->nullable();
			$table->timestamp('dateDebutAmortissement');
			$table->text('description')->nullable();
			$table->string('statut', 255)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('creances_dettes_fonds');
	}
}