<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCentersTable extends Migration {

	public function up()
	{
		Schema::create('user_centers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('center_id')->unsigned()->index();
			$table->tinyInteger('is_default')->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('user_centers');
	}
}