<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('customer_type_id')->references('id')->on('customer_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_contacts', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_contacts', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_remarks', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_remarks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_tags', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customer_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('center_id')->references('id')->on('centers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('meal_provision_id')->references('id')->on('meal_provisions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('comfort_type_id')->references('id')->on('comfort_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('block_id')->references('id')->on('blocks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_rooms', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_rooms', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_rooms', function(Blueprint $table) {
			$table->foreign('room_type_id')->references('id')->on('room_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_materials', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_materials', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_presences', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_presences', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('center_id')->references('id')->on('centers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('block_id')->references('id')->on('blocks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('location_type_id')->references('id')->on('location_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_locations', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_locations', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('room_room_types', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('room_room_types', function(Blueprint $table) {
			$table->foreign('room_type_id')->references('id')->on('room_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('consumptions', function(Blueprint $table) {
			$table->foreign('center_id')->references('id')->on('centers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_consumptions', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_consumptions', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_consumptions', function(Blueprint $table) {
			$table->foreign('consumption_id')->references('id')->on('consumptions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('location_activities', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('location_activities', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_activities', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_activities', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_remarks', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_remarks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meal_types', function(Blueprint $table) {
			$table->foreign('center_id')->references('id')->on('centers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meal_provision_types', function(Blueprint $table) {
			$table->foreign('meal_provision_id')->references('id')->on('meal_provisions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('meal_provision_types', function(Blueprint $table) {
			$table->foreign('meal_type_id')->references('id')->on('meal_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_meals', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_meals', function(Blueprint $table) {
			$table->foreign('meal_type_id')->references('id')->on('meal_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->foreign('block_type_id')->references('id')->on('block_type')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->foreign('center_id')->references('id')->on('centers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_diets', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('booking_diets', function(Blueprint $table) {
			$table->foreign('diet_id')->references('id')->on('diets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_centers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_centers', function(Blueprint $table) {
			$table->foreign('center_id')->references('id')->on('centers')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_customer_type_id_foreign');
		});
		Schema::table('customer_contacts', function(Blueprint $table) {
			$table->dropForeign('customer_contacts_customer_id_foreign');
		});
		Schema::table('customer_contacts', function(Blueprint $table) {
			$table->dropForeign('customer_contacts_contact_id_foreign');
		});
		Schema::table('customer_remarks', function(Blueprint $table) {
			$table->dropForeign('customer_remarks_customer_id_foreign');
		});
		Schema::table('customer_remarks', function(Blueprint $table) {
			$table->dropForeign('customer_remarks_user_id_foreign');
		});
		Schema::table('customer_tags', function(Blueprint $table) {
			$table->dropForeign('customer_tags_customer_id_foreign');
		});
		Schema::table('customer_tags', function(Blueprint $table) {
			$table->dropForeign('customer_tags_tag_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_center_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_customer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_meal_provision_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_comfort_type_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_block_id_foreign');
		});
		Schema::table('booking_rooms', function(Blueprint $table) {
			$table->dropForeign('booking_rooms_booking_id_foreign');
		});
		Schema::table('booking_rooms', function(Blueprint $table) {
			$table->dropForeign('booking_rooms_room_id_foreign');
		});
		Schema::table('booking_rooms', function(Blueprint $table) {
			$table->dropForeign('booking_rooms_room_type_id_foreign');
		});
		Schema::table('booking_materials', function(Blueprint $table) {
			$table->dropForeign('booking_materials_booking_id_foreign');
		});
		Schema::table('booking_materials', function(Blueprint $table) {
			$table->dropForeign('booking_materials_material_id_foreign');
		});
		Schema::table('booking_presences', function(Blueprint $table) {
			$table->dropForeign('booking_presences_booking_id_foreign');
		});
		Schema::table('booking_presences', function(Blueprint $table) {
			$table->dropForeign('booking_presences_room_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_center_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_block_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_parent_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_location_type_id_foreign');
		});
		Schema::table('booking_locations', function(Blueprint $table) {
			$table->dropForeign('booking_locations_booking_id_foreign');
		});
		Schema::table('booking_locations', function(Blueprint $table) {
			$table->dropForeign('booking_locations_location_id_foreign');
		});
		Schema::table('room_room_types', function(Blueprint $table) {
			$table->dropForeign('room_room_types_room_id_foreign');
		});
		Schema::table('room_room_types', function(Blueprint $table) {
			$table->dropForeign('room_room_types_room_type_id_foreign');
		});
		Schema::table('consumptions', function(Blueprint $table) {
			$table->dropForeign('consumptions_center_id_foreign');
		});
		Schema::table('booking_consumptions', function(Blueprint $table) {
			$table->dropForeign('booking_consumptions_booking_id_foreign');
		});
		Schema::table('booking_consumptions', function(Blueprint $table) {
			$table->dropForeign('booking_consumptions_location_id_foreign');
		});
		Schema::table('booking_consumptions', function(Blueprint $table) {
			$table->dropForeign('booking_consumptions_consumption_id_foreign');
		});
		Schema::table('location_activities', function(Blueprint $table) {
			$table->dropForeign('location_activities_location_id_foreign');
		});
		Schema::table('location_activities', function(Blueprint $table) {
			$table->dropForeign('location_activities_activity_id_foreign');
		});
		Schema::table('booking_activities', function(Blueprint $table) {
			$table->dropForeign('booking_activities_booking_id_foreign');
		});
		Schema::table('booking_activities', function(Blueprint $table) {
			$table->dropForeign('booking_activities_activity_id_foreign');
		});
		Schema::table('booking_remarks', function(Blueprint $table) {
			$table->dropForeign('booking_remarks_booking_id_foreign');
		});
		Schema::table('booking_remarks', function(Blueprint $table) {
			$table->dropForeign('booking_remarks_user_id_foreign');
		});
		Schema::table('meal_types', function(Blueprint $table) {
			$table->dropForeign('meal_types_center_id_foreign');
		});
		Schema::table('meal_provision_types', function(Blueprint $table) {
			$table->dropForeign('meal_provision_types_meal_provision_id_foreign');
		});
		Schema::table('meal_provision_types', function(Blueprint $table) {
			$table->dropForeign('meal_provision_types_meal_type_id_foreign');
		});
		Schema::table('booking_meals', function(Blueprint $table) {
			$table->dropForeign('booking_meals_booking_id_foreign');
		});
		Schema::table('booking_meals', function(Blueprint $table) {
			$table->dropForeign('booking_meals_meal_type_id_foreign');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->dropForeign('blocks_block_type_id_foreign');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->dropForeign('blocks_center_id_foreign');
		});
		Schema::table('booking_diets', function(Blueprint $table) {
			$table->dropForeign('booking_diets_booking_id_foreign');
		});
		Schema::table('booking_diets', function(Blueprint $table) {
			$table->dropForeign('booking_diets_diet_id_foreign');
		});
		Schema::table('user_centers', function(Blueprint $table) {
			$table->dropForeign('user_centers_user_id_foreign');
		});
		Schema::table('user_centers', function(Blueprint $table) {
			$table->dropForeign('user_centers_center_id_foreign');
		});
	}
}