<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Block extends Eloquent {

	protected $table = 'blocks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->hasOne('App\Models\BlockType');
	}

	public function rooms()
	{
		return $this->hasMany('App\Models\Room');
	}

}