<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Booking extends Eloquent {

	protected $table = 'bookings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->hasOne('App\Models\BookingStatus', 'status_id');
	}

	public function rooms()
	{
		return $this->hasMany('App\Models\BookingRoom');
	}

	public function materials()
	{
		return $this->hasMany('App\Models\BookingMaterial');
	}

	public function presences()
	{
		return $this->hasMany('App\Models\BookingPresence');
	}

	public function locations()
	{
		return $this->hasMany('App\Models\BookingLocation');
	}

	public function consumptions()
	{
		return $this->hasMany('App\Models\BookingConsumption');
	}

	public function activities()
	{
		return $this->hasOne('App\Models\BookingActivity');
	}

	public function customer()
	{
		return $this->hasOne('App\Models\Customer');
	}

	public function remarks()
	{
		return $this->hasMany('App\Models\BookingRemark');
	}

	public function meals()
	{
		return $this->hasMany('App\Models\BookingMeal');
	}

	public function diets()
	{
		return $this->hasMany('App\Models\BookingDiet');
	}

}