<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BookingConsumption extends Eloquent {

	protected $table = 'booking_consumptions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function consumption()
	{
		return $this->hasOne('App\Models\Consumption');
	}

	public function location()
	{
		return $this->hasOne('App\Models\Location');
	}

}