<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchaseInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('purchase_invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->nullable();
			$table->string('code')->nullable();
			$table->date('date')->nullable();
			$table->float('total')->default('0');
			$table->integer('created_by')->nullable();
			$table->integer('confirmed_by')->nullable();
			$table->integer('confirmed_at');
			$table->string('status', 10)->default('OPEN');
		});
	}

	public function down()
	{
		Schema::drop('purchase_invoices');
	}
}