<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->json('name')->nullable();
			$table->string('telephone', 255);
			$table->string('phone', 255)->nullable();
			$table->json('address')->nullable();
			$table->json('governorate')->nullable();
			$table->json('country')->nullable();
			$table->string('commercial_number', 255)->nullable();
			$table->string('taxes_card', 255)->nullable();
			$table->text('policies')->nullable();
			$table->string('code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}