<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('title');
			$table->string('subtitle')->nullable();
			$table->string('slug')->nullable();
			$table->string('code')->nullable()->default('NOVERIFY');
			$table->boolean('is_active')->default(false);
			$table->boolean('is_featured')->default(false);
			$table->boolean('is_maintenance')->default(false);
			$table->text('logo_url')->nullable();
			$table->text('banner_url')->nullable();
			$table->text('helper_url');
			$table->mediumText('description')->nullable();
			$table->longText('long_description')->nullable();
			$table->integer('ordered')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}