<?php

namespace Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemSection extends Model 
{

    protected $table = 'item_sections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_id', 'title', 'ordered', 'is_active');

    public function product()
    {
        return $this->belongsTo('App\Models\Product', 'product_id');
    }

    public function items()
    {
        return $this->hasMany('Products\Item');
    }

}