<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name');
			$table->string('email', 255)->unique();
			$table->integer('phone');
			$table->enum('gender', array('Male', 'Female'));
			$table->integer('national_id')->nullable();
			$table->date('birthday');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}