<?php

namespace App\Models;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('status', 'name', 'email', 'phone', 'contact_num', 'watts_num', 'min_order_price', 'password', 'delivery_price', 'avg_rate', 'image', 'reset_code', 'district_id');

	public function district()
	{
		return $this->belongsTo('App\Models\District');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function meals()
	{
		return $this->hasMany('App\Models\Meal');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function commissions()
	{
		return $this->hasMany('App\Models\Commision');
	}

	public function offers()
	{
		return $this->hasMany('App\Models\Offer');
	}

	public function notifications()
	{
		return $this->morphToMany('App\Models\Notification');
	}

}