<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->string('original_name');
			$table->string('original_ext', 12);
			$table->bigInteger('filesize')->unsigned();
			$table->text('path');
			$table->string('type');
			$table->morphs('related_model');
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}