<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	public function up()
	{
		Schema::create('activities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('category_id');
			$table->string('description');
			$table->string('address');
			$table->string('city');
			$table->string('postal_code');
			$table->string('state');
			$table->string('country');
			$table->string('channel');
			$table->string('creator_id');
			$table->boolean('is_free');
			$table->decimal('price');
			$table->smallInteger('currency');
			$table->string('status');
		});
	}

	public function down()
	{
		Schema::drop('activities');
	}
}