<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('invite', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visitor', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_visitor', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('group_visitor_details', function(Blueprint $table) {
			$table->foreign('group_visitor_id')->references('id')->on('group_visitor')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('invite', function(Blueprint $table) {
			$table->dropForeign('invite_user_id_foreign');
		});
		Schema::table('visitor', function(Blueprint $table) {
			$table->dropForeign('visitor_user_id_foreign');
		});
		Schema::table('group_visitor', function(Blueprint $table) {
			$table->dropForeign('group_visitor_user_id_foreign');
		});
		Schema::table('group_visitor_details', function(Blueprint $table) {
			$table->dropForeign('group_visitor_details_group_visitor_id_foreign');
		});
	}
}