<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('sku', 32);
			$table->integer('category_id')->unsigned();
			$table->integer('brand_id');
			$table->integer('unit_id');
			$table->string('name', 32);
			$table->string('image');
			$table->string('description', 64);
			$table->string('slug', 32);
			$table->integer('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}