<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('chinhanh_id')->references('id')->on('chinhanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('phongban_id')->references('id')->on('phongban')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('trangthai_nhanvien_id')->references('id')->on('trangthai_nhanvien')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('thuongtru_quanhuyen_id')->references('id')->on('quanhuyen')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('thuongtru_tinhthanh_id')->references('id')->on('tinhthanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('tamtru_quanhuyen_id')->references('id')->on('quanhuyen')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('tamtru_tinhthanh_id')->references('id')->on('tinhthanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->foreign('tinhthanh_id')->references('id')->on('tinhthanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->foreign('quanhuyen_id')->references('id')->on('quanhuyen')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->foreign('xaphuong_id')->references('id')->on('xaphuong')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phongban', function(Blueprint $table) {
			$table->foreign('chinhanh_id')->references('id')->on('chinhanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phongban', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phongban', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->foreign('phongban_id')->references('id')->on('phongban')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->foreign('nhom_kh_id')->references('id')->on('nhom_khachhang')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('congviec', function(Blueprint $table) {
			$table->foreign('phongban_id')->references('id')->on('phongban')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('congviec', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('congviec', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yecau_comment', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yecau_comment', function(Blueprint $table) {
			$table->foreign('yeucau_id')->references('id')->on('yeucau')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('quanhuyen_id')->references('id')->on('quanhuyen')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('tinhthanh_id')->references('id')->on('tinhthanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('hethongketnoi_id')->references('id')->on('hethong_ketnoi')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('nhom_khachhang_id')->references('id')->on('nhom_khachhang')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('chinhanh_id')->references('id')->on('chinhanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->foreign('ma_congviec_id')->references('id')->on('congviec')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->foreign('bophan_xuly_id')->references('id')->on('phongban')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->foreign('nhanvien_xuly_id')->references('id')->on('nhanvien')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->foreign('trangthai_chitiet_id')->references('id')->on('trangthai_yeucau')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->foreign('chinhanh_xuly_id')->references('id')->on('chinhanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('trangthai_yeucau', function(Blueprint $table) {
			$table->foreign('phongban_id')->references('id')->on('phongban')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('trangthai_yeucau', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('trangthai_yeucau', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('hethong_ketnoi', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('hethong_ketnoi', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tinhthanh', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('tinhthanh', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('quanhuyen', function(Blueprint $table) {
			$table->foreign('tinhthanh_id')->references('id')->on('tinhthanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('quanhuyen', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('quanhuyen', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phamvi', function(Blueprint $table) {
			$table->foreign('cauhinhtiendo_id')->references('id')->on('cauhinhtiendo')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phamvi', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phamvi', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhom_khachhang', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('nhom_khachhang', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trangthai_nhanvien', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('trangthai_nhanvien', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->foreign('tinhthanh_id')->references('id')->on('tinhthanh')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->foreign('quanhuyen_id')->references('id')->on('quanhuyen')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->foreign('updated_by')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('menu_links', function(Blueprint $table) {
			$table->foreign('menu_parent_id')->references('id')->on('menu')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('phongban_permission', function(Blueprint $table) {
			$table->foreign('phongban_id')->references('id')->on('phongban')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('phongban_permission', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_chinhanh_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_phongban_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_user_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_trangthai_nhanvien_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_thuongtru_quanhuyen_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_thuongtru_tinhthanh_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_tamtru_quanhuyen_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_tamtru_tinhthanh_id_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_created_by_foreign');
		});
		Schema::table('nhanvien', function(Blueprint $table) {
			$table->dropForeign('nhanvien_updated_by_foreign');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->dropForeign('chinhanh_tinhthanh_id_foreign');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->dropForeign('chinhanh_quanhuyen_id_foreign');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->dropForeign('chinhanh_xaphuong_id_foreign');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->dropForeign('chinhanh_created_by_foreign');
		});
		Schema::table('chinhanh', function(Blueprint $table) {
			$table->dropForeign('chinhanh_updated_by_foreign');
		});
		Schema::table('phongban', function(Blueprint $table) {
			$table->dropForeign('phongban_chinhanh_id_foreign');
		});
		Schema::table('phongban', function(Blueprint $table) {
			$table->dropForeign('phongban_created_by_foreign');
		});
		Schema::table('phongban', function(Blueprint $table) {
			$table->dropForeign('phongban_updated_by_foreign');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->dropForeign('cauhinhtiendo_phongban_id_foreign');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->dropForeign('cauhinhtiendo_nhom_kh_id_foreign');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->dropForeign('cauhinhtiendo_created_by_foreign');
		});
		Schema::table('cauhinhtiendo', function(Blueprint $table) {
			$table->dropForeign('cauhinhtiendo_updated_by_foreign');
		});
		Schema::table('congviec', function(Blueprint $table) {
			$table->dropForeign('congviec_phongban_id_foreign');
		});
		Schema::table('congviec', function(Blueprint $table) {
			$table->dropForeign('congviec_created_by_foreign');
		});
		Schema::table('congviec', function(Blueprint $table) {
			$table->dropForeign('congviec_updated_by_foreign');
		});
		Schema::table('yecau_comment', function(Blueprint $table) {
			$table->dropForeign('yecau_comment_user_id_foreign');
		});
		Schema::table('yecau_comment', function(Blueprint $table) {
			$table->dropForeign('yecau_comment_yeucau_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_created_by_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_updated_by_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_quanhuyen_id_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_tinhthanh_id_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_hethongketnoi_id_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_nhom_khachhang_id_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_user_id_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_chinhanh_id_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_created_by_foreign');
		});
		Schema::table('khachang', function(Blueprint $table) {
			$table->dropForeign('khachang_updated_by_foreign');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->dropForeign('yeucau_ma_congviec_id_foreign');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->dropForeign('yeucau_bophan_xuly_id_foreign');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->dropForeign('yeucau_nhanvien_xuly_id_foreign');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->dropForeign('yeucau_trangthai_chitiet_id_foreign');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->dropForeign('yeucau_chinhanh_xuly_id_foreign');
		});
		Schema::table('yeucau', function(Blueprint $table) {
			$table->dropForeign('yeucau_user_id_foreign');
		});
		Schema::table('trangthai_yeucau', function(Blueprint $table) {
			$table->dropForeign('trangthai_yeucau_phongban_id_foreign');
		});
		Schema::table('trangthai_yeucau', function(Blueprint $table) {
			$table->dropForeign('trangthai_yeucau_created_by_foreign');
		});
		Schema::table('trangthai_yeucau', function(Blueprint $table) {
			$table->dropForeign('trangthai_yeucau_updated_by_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_created_by_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_updated_by_foreign');
		});
		Schema::table('hethong_ketnoi', function(Blueprint $table) {
			$table->dropForeign('hethong_ketnoi_created_by_foreign');
		});
		Schema::table('hethong_ketnoi', function(Blueprint $table) {
			$table->dropForeign('hethong_ketnoi_updated_by_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('tinhthanh', function(Blueprint $table) {
			$table->dropForeign('tinhthanh_created_by_foreign');
		});
		Schema::table('tinhthanh', function(Blueprint $table) {
			$table->dropForeign('tinhthanh_updated_by_foreign');
		});
		Schema::table('quanhuyen', function(Blueprint $table) {
			$table->dropForeign('quanhuyen_tinhthanh_id_foreign');
		});
		Schema::table('quanhuyen', function(Blueprint $table) {
			$table->dropForeign('quanhuyen_created_by_foreign');
		});
		Schema::table('quanhuyen', function(Blueprint $table) {
			$table->dropForeign('quanhuyen_updated_by_foreign');
		});
		Schema::table('phamvi', function(Blueprint $table) {
			$table->dropForeign('phamvi_cauhinhtiendo_id_foreign');
		});
		Schema::table('phamvi', function(Blueprint $table) {
			$table->dropForeign('phamvi_created_by_foreign');
		});
		Schema::table('phamvi', function(Blueprint $table) {
			$table->dropForeign('phamvi_updated_by_foreign');
		});
		Schema::table('nhom_khachhang', function(Blueprint $table) {
			$table->dropForeign('nhom_khachhang_created_by_foreign');
		});
		Schema::table('nhom_khachhang', function(Blueprint $table) {
			$table->dropForeign('nhom_khachhang_updated_by_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_created_by_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_updated_by_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('trangthai_nhanvien', function(Blueprint $table) {
			$table->dropForeign('trangthai_nhanvien_created_by_foreign');
		});
		Schema::table('trangthai_nhanvien', function(Blueprint $table) {
			$table->dropForeign('trangthai_nhanvien_updated_by_foreign');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->dropForeign('xaphuong_tinhthanh_id_foreign');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->dropForeign('xaphuong_quanhuyen_id_foreign');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->dropForeign('xaphuong_created_by_foreign');
		});
		Schema::table('xaphuong', function(Blueprint $table) {
			$table->dropForeign('xaphuong_updated_by_foreign');
		});
		Schema::table('menu_links', function(Blueprint $table) {
			$table->dropForeign('menu_links_menu_parent_id_foreign');
		});
		Schema::table('phongban_permission', function(Blueprint $table) {
			$table->dropForeign('phongban_permission_phongban_id_foreign');
		});
		Schema::table('phongban_permission', function(Blueprint $table) {
			$table->dropForeign('phongban_permission_permission_id_foreign');
		});
	}
}